<?php

namespace Modules\Common\Entities\Policies;

use Illuminate\Auth\Access\HandlesAuthorization;

use Modules\Common\Entities\User;
use Modules\Common\Entities\Report;

class ReportPolicy
{
    use HandlesAuthorization;

    public function write(User $user, Report $report)
    {
        // Authorize user if report belongs it or a member of its organization
        return ($user->id == $report->user_id) || ($user->id == $report->user->organization_id);
    }

    // End of class
}
